<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class InstrumentTerm extends Model
{

    protected $table = 'instrument_terms';
    protected $fillable = [
        'instrument_id',
        'can_cancel_before_booking_slot',
        'approval_required',
        'approval_from',
        'sop',
        'maximum_booking_type',
        'maximum_bookings',
        'maximum_booking_for',
        'maximum_sample_booking_per_day',
        'instrument_sample_questions',
        'booking_slot_duration',
    ];

    public function instrument()
    {
        return $this->belongsTo(Instrument::class);
    }
}
