<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Boxfield extends Model
{
    protected $fillable = [
        'lab_id',
        'box_name',
        'status',
    ];

    protected $casts = [
        'status' => 'boolean',
    ];

    public function subBoxes(): HasMany
    {
        return $this->hasMany(SubBox::class, 'box_id');
    }

    public function lab(): BelongsTo
    {
        return $this->belongsTo(Lab::class, 'lab_id');
    }
}
