<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Booking extends Model
{
    protected $fillable = ['instrument_id', 'student_id', 'date', 'status', 'description', 'booking_type', 'booked_by', 'booking_cost', 'sample_quantity'];

    public function instrument()
    {
        return $this->belongsTo(Instrument::class);
    }

    public function student()
    {
        return $this->belongsTo(Student::class);
    }
    public function principalInvestigator()
    {
        return $this->belongsTo(PrincipalInvestigator::class, 'student.principal_investigator_id');
    }

    public function slots()
    {
        return $this->belongsToMany(Slot::class, 'booking_slot')
            ->withTimestamps();
    }


    public function getFirstSlotAttribute()
    {
        return $this->slots()->orderBy('start_time')->first();
    }
}
