<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class QuotationMail extends Mailable
{
    use Queueable, SerializesModels;

    public $customerName;
    public $organization;
    public $email;
    public $phone;
    public $instruments;
    public $charges;

    public function __construct($customerName, $organization, $email, $phone, $instruments, $charges)
    {
        $this->customerName = $customerName;
        $this->organization = $organization;
        $this->email = $email;
        $this->phone = $phone;
        $this->instruments = $instruments;
        $this->charges = $charges;
    }

    public function build()
    {
        return $this->subject('Quotation for Instrument Booking')
                    ->view('emails.QuotationMail');
    }
}