<?php

namespace App\Mail;

use App\Models\PrincipalInvestigator;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class LowBalanceReminderMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $pi;

    public function __construct(PrincipalInvestigator $pi)
    {
        $this->pi = $pi;
    }

    public function build()
    {
        return $this->markdown('emails.low-balance-reminder')
                    ->subject('Low Balance Alert - Action Required')
                    ->with([
                        'name' => $this->pi->getFullNameAttribute(),
                        'currentBalance' => $this->pi->available_funds,
                        'email' => $this->pi->email
                    ]);
    }
}