<?php
namespace App\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Tenant;
use App\Helpers\TenantConnector;

class TenantForm extends Component
{
    use WithPagination;

    public $name;
    public $database;
    public $username;
    public $password;
    public $showForm = false;
    public $search = '';
public $isEditing = false;


    protected $paginationTheme = 'tailwind'; // Optional: Bootstrap if you're using Bootstrap

    // public $showForm = false;

public function showCreateForm()
{
    $this->reset(['name', 'database', 'username', 'password']);
    $this->isEditing = false;
    $this->showForm = true;
}

public function hideCreateForm()
{
    $this->showForm = false;
    $this->resetErrorBag();
    $this->reset(['name', 'database', 'username', 'password', 'isEditing']);
}

    public function updatedSearch()
    {
        $this->resetPage(); // Reset to page 1 when searching
    }

    

    

    public function save()
    {
        $this->validate([
            'name'     => 'required|string|unique:tenants,name',
            'database' => 'required|string|unique:tenants,database',
            'username' => 'required|string',
            'password' => 'nullable|string',
        ]);

        $tenant = Tenant::create([
            'name'     => $this->name,
            'database' => $this->database,
            'username' => $this->username,
            'password' => $this->password,
        ]);

        TenantConnector::createAndMigrateTenant($tenant->name);


        session()->flash('success', 'Tenant created successfully.');
        $this->reset(['name', 'database', 'username', 'password']);
        $this->showForm = false;
    }

    public function render()
    {
        $tenants = Tenant::query()
            ->when($this->search, fn($query) =>
                $query->where('name', 'like', '%' . $this->search . '%')
            )
            ->latest()
            ->paginate(10);

        return view('livewire.tenant-form', [
            'tenants' => $tenants,
        ]);
    }
}
