<?php

namespace App\Livewire\Pi;

use Livewire\Component;
use Livewire\WithPagination;

class PiView extends Component
{
    use WithPagination;

    public $pi;
    public $search_date = '';

    public function hideViewPi()
    {
        $this->dispatch('hideViewPi');
    }

    public function getBookings()
    {
        $bookings = $this->pi->getAllPiBookings();

        // Apply date filter if search_date is set
        if ($this->search_date) {
            $bookings = $bookings->filter(function($booking) {
                return $booking->date == $this->search_date;
            });
        }

        // Sort the bookings
        $sorted = $bookings->sortByDesc(function($booking) {
            return $booking->date . ' ' . optional($booking->slots->first())->start_time;
        });

        // Manual pagination
        return $this->paginateCollection($sorted, 10);
    }

    protected function paginateCollection($items, $perPage)
    {
        $page = \Illuminate\Pagination\Paginator::resolveCurrentPage('page');
        $items = $items instanceof \Illuminate\Support\Collection ? $items : \Illuminate\Support\Collection::make($items);

        return new \Illuminate\Pagination\LengthAwarePaginator(
            $items->forPage($page, $perPage),
            $items->count(),
            $perPage,
            $page,
            [
                'path' => \Illuminate\Pagination\Paginator::resolveCurrentPath(),
                'pageName' => 'page',
            ]
        );
    }

    public function render()
    {
        return view('livewire.pi.pi-view', [
            'bookings' => $this->getBookings()
        ]);
    }
}
