<?php

namespace App\Livewire\Inventory;

use App\Models\Boxfield;
use App\Models\SubBox;
use Livewire\Component;

class SubBoxes extends Component
{
    public $boxId = null;
    public $isBoxActive = null;
    public $box = null;
    public $sub_box_name;
    public $status = 1;

    public $showAddNewSubBoxModel = false;
    public $isEditing = false;
    public $subBoxId = null;

    protected $listeners = [
        'editSubBox' => 'loadSubBoxData',
        'resetForm' => 'resetForm'
    ];

    public function mount($boxId)
    {
        $this->boxId = $boxId;
        $this->box = Boxfield::findOrFail($boxId);

        if ($this->box->status)
        {
            $this->isBoxActive = true;
        }
        else
        {
            $this->isBoxActive = false;
        }

    }

    protected function rules()
    {
        return [
            'sub_box_name' => 'required|string|max:255',
        ];
    }

    public function toggleShowAddNewSubBoxModel()
    {
        $this->showAddNewSubBoxModel = true;
    }

    public function closeAddNewSubBoxModel()
    {
        $this->showAddNewSubBoxModel = false;
        $this->resetForm();
    }

    public function loadSubBoxData($subBoxId)
    {
        $this->subBoxId = $subBoxId;
        $this->isEditing = true;
        $subBox = SubBox::findOrFail($subBoxId);

        $this->sub_box_name = $subBox->sub_box_name;
        $this->status = $subBox->status;
        $this->showAddNewSubBoxModel = true;
    }

    public function toggleStatus($subBoxId)
    {
        $subBox = SubBox::findOrFail($subBoxId);
        $subBox->status = !$subBox->status;
        $subBox->save();

        session()->flash('success', 'Sub box status updated successfully!');
    }

    public function saveSubBox()
    {
        $this->validate();

        if ($this->isEditing) {
            $this->updateSubBox();
        } else {
            $this->createSubBox();
        }
    }

    public function createSubBox()
    {
        $subBox = new SubBox();
        $subBox->box_id = $this->boxId;
        $subBox->sub_box_name = $this->sub_box_name;
        $subBox->status = $this->status;
        $subBox->save();

        $this->resetForm();
        $this->closeAddNewSubBoxModel();
        session()->flash('success', 'Sub box created successfully!');

        $this->dispatch('subBoxCreated');
    }

    public function updateSubBox()
    {
        $subBox = SubBox::findOrFail($this->subBoxId);
        $subBox->sub_box_name = $this->sub_box_name;
        $subBox->status = $this->status;
        $subBox->save();

        $this->resetForm();
        $this->closeAddNewSubBoxModel();
        session()->flash('success', 'Sub box updated successfully!');

        $this->dispatch('subBoxUpdated');
    }

    public function deleteSubBox($subBoxId)
    {
        $subBox = SubBox::findOrFail($subBoxId);
        $subBox->delete();

        session()->flash('success', 'Sub box deleted successfully!');
        $this->dispatch('subBoxDeleted');
    }

    public function resetForm()
    {
        $this->reset([
            'sub_box_name',
            'isEditing',
            'subBoxId'
        ]);

        $this->status = 1;
    }

    public function render()
    {
        $subBoxes = SubBox::where('box_id', $this->boxId)
                          ->withCount('itemsSlots')
                          ->orderBy('created_at', 'desc')
                          ->get();

        return view('livewire.inventory.sub-boxes', [
            'subBoxes' => $subBoxes
        ]);
    }
}
