<?php

namespace App\Livewire\Instruments;

use App\Models\InstrumentService;
use Livewire\Component;

class ViewInstrumentServiceDetails extends Component
{
    public $instrument;
    public $service;
    public $serviceId;

    public function mount($instrument)
    {
        $this->serviceId = $instrument;
        $this->service = InstrumentService::with('instrument')->findOrFail($instrument);
    }

    public function hideViewInstrumentServiceDetails()
    {
        $this->dispatch('hideInstrumentDetails');
    }

    public function render()
    {
        return view('livewire.instruments.view-instrument-service-details');
    }
}
