<?php

namespace App\Livewire\Funds;

use App\Models\PrincipalInvestigator;
use App\Models\piFund;
use Livewire\Component;

class AddFundForm extends Component
{
    public $selectedPI = null;
    public $principal_investigator_id;
    public $amount;
    public $fundId;

    protected $rules = [
        'principal_investigator_id' => 'required|exists:principal_investigators,id',
        'amount' => 'required|numeric|min:1'
    ];

    public function mount($selectedPI = null, $fundId = null)
    {
        $this->selectedPI = $selectedPI;
        $this->fundId = $fundId;

        if ($this->fundId) {
            $fund = piFund::find($this->fundId);
            if ($fund) {
                $this->principal_investigator_id = $fund->principal_investigator_id;
                $this->amount = $fund->amount;
            }
        } elseif ($selectedPI) {
            $this->principal_investigator_id = $selectedPI;
        }
    }

    public function submitFunds()
    {
        $this->validate();

        if ($this->fundId) {
            $fund = piFund::find($this->fundId);
            if ($fund) {
                $pi = PrincipalInvestigator::find($this->principal_investigator_id);
                $oldAmount = $fund->amount;
                $difference = $this->amount - $oldAmount;
                
                \DB::transaction(function () use ($fund, $pi, $difference) {
                    $fund->update([
                        'principal_investigator_id' => $this->principal_investigator_id,
                        'amount' => $this->amount
                    ]);

                    $pi->update([
                        'available_funds' => $pi->available_funds + $difference
                    ]);
                });

                $this->dispatch('fundUpdated');
            }
        } else {
            \DB::transaction(function () {
                $fund = piFund::create([
                    'principal_investigator_id' => $this->principal_investigator_id,
                    'amount' => $this->amount
                ]);

                $pi = PrincipalInvestigator::find($this->principal_investigator_id);
                $pi->update([
                    'available_funds' => $pi->available_funds + $this->amount
                ]);
            });

            $this->dispatch('fundAdded');
        }

        $this->reset(['principal_investigator_id', 'amount', 'fundId']);
    }

    public function cancel()
    {
        $this->dispatch('closeAddFundForm');
    }

    public function render()
    {
        $investigators = $this->selectedPI
            ? PrincipalInvestigator::where('id', $this->selectedPI)->get()
            : PrincipalInvestigator::all();

        return view('livewire.funds.add-fund-form', [
            'investigators' => $investigators
        ]);
    }
}
