<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Helpers\TenantConnector;


class RunTenantMigration
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        $host = $request->getHost();

        // $subdomain = explode('.', $host)[0];
        $subdomain=$host;
        try {
            TenantConnector::connectMigrate($subdomain);
            \Log::info("Connected to tenant: " . DB::connection()->getDatabaseName());
        } catch (\Exception $e) {
            // dd($e);
            \Log::error("Tenant connection failed: " . $e->getMessage());
            abort(500, 'Tenant connection error');
        }
        if (!\App\Models\Tenant::where('subdomain', $subdomain)->exists()) {
            return response()->json(['error' => 'Invalid subdomain'], 404);
        }

        return $next($request);
    }
}
