<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Helpers\TenantConnector;
use Illuminate\Support\Facades\DB;

class IdentifyTenant
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $host = $request->getHost();
       
        if($host == env('APP_URL')){
            // dd("heelo");
            return $next($request);

        }else{
        
         $subdomain = explode('.', $host)[0];
     
      try {
        TenantConnector::connectFromSubdomain($subdomain);
        \Log::info("Connected to tenant: " . DB::connection()->getDatabaseName());
    } catch (\Exception $e) {
        // dd($e);
        \Log::error("Tenant connection failed: " . $e->getMessage());
        abort(500, 'Tenant connection error');
    }


        return $next($request);
        }
        // return $next($request);
    }
}
