<?php

namespace App\Http\Controllers;

use App\Mail\ContactFormMail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class ContactController extends Controller
{
    public function submit(Request $request)
    {

        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'required|string|max:20',
            'subject' => 'required|string|max:255',
            'message' => 'required|string',
            'g-recaptcha-response' => 'required|captcha',
        ]);

        // Send email
        Mail::to('vcdiamond507@gmail.com')->send(new ContactFormMail($validated));
//        Mail::to('md@himsoftsolution.com')->queue(new ContactFormMail($validated));

        // Return with success message
        return back()->with('success', 'Thank you for your message. We will contact you soon!');
    }
}
