<?php
// app/Helpers/TenantConnector.php

namespace App\Helpers;

use App\Models\Tenant;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Artisan;

class TenantConnector
{
    public static function connectFromSubdomain(string $subdomain)
    {
        // Example: find tenant by subdomain (you can change to ID or route param)
        $tenant = Tenant::where('name', $subdomain)->firstOrFail();
       
        // dd($tenant);

        config([
            'database.connections.tenant' => [
                'driver'    => 'mysql',
                'host'      => '127.0.0.1',
                'port'      => 3306,
                'database'  => $tenant->database,
                'username'  => $tenant->username,
                'password'  => $tenant->password,
                'charset'   => 'utf8mb4',
                'collation' => 'utf8mb4_unicode_ci',
            ],
        ]);

        // Optional: switch default connection
        // DB::purge('tenant');
DB::setDefaultConnection('tenant');
        // DB::setDefaultConnection('tenant');
        
        // dd("heelo");
    }
/**
     * Create DB (if not exists), connect, and migrate
     */
    public static function createAndMigrateTenant(string $subdomain): void
    {
         
        $tenant = Tenant::where('name', $subdomain)->firstOrFail();

        // 1. Create database if it doesn't exist
//        DB::statement("CREATE DATABASE IF NOT EXISTS `{$tenant->database}`");

        // 2. Connect to the new tenant database
        self::connectFromSubdomain($subdomain);

        // 3. Run default migrations
        Artisan::call('migrate', [
            '--database' => 'tenant',
            '--force' => true,
            '--seed'     => true, // ← this runs DatabaseSeeder
        ]);

        DB::connection('tenant')->table('tenants')->insert([
            'id' => $tenant->id,
            'name' => $tenant->name,
            'database' => $tenant->database,
            'username' => $tenant->username,
            'password' => $tenant->password,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }
    
     public static function connectMigrate()
    {
        $tenants = Tenant::all();

        if ($tenants->isEmpty()) {
            logger()->error('No tenants found in database');
            return;
        }

        foreach ($tenants as $tenant) {
            try {
                if (empty($tenant->name)) {
                    logger()->warning("Skipping tenant with no name", ['tenant_id' => $tenant->id]);
                    continue;
                }

                self::connectFromTenant($tenant); // ✅ updated method name

                Artisan::call('migrate', [
                    '--database' => 'tenant',
                    '--force' => true,
                ]);

                logger()->debug('Migrated tenant', ['tenant' => $tenant->toArray()]);
            } catch (\Exception $e) {
                logger()->error("Tenant connection failed: " . $e->getMessage());
            }
        }

        dd("Migration completed");
    }


    public static function connectFromTenant(Tenant $tenant)
    {
        config([
            'database.connections.tenant' => [
                'driver'    => 'mysql',
                'host'      => '127.0.0.1',
                'port'      => 3306,
                'database'  => $tenant->database,
                'username'  => $tenant->username,
                'password'  => $tenant->password,
                'charset'   => 'utf8mb4',
                'collation' => 'utf8mb4_unicode_ci',
            ],
        ]);

        DB::purge('tenant'); // Important to avoid old connection cache
        DB::setDefaultConnection('tenant');
    }
}
