<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class TechnicianExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize, WithStyles
{
    protected $query;

    public function __construct($query)
    {
        $this->query = $query;
    }

    public function collection()
    {
        return $this->query->get();
    }

    public function headings(): array
    {
        return [
            'Sr. No.',
            'Name',
            'Email',
            'Phone',
            'Department',
            'Designation',
            'Specialization',
            'Qualification',
            'Status',
            'Created At'
        ];
    }

    public function map($technician): array
    {
        static $rowNumber = 0;
        $rowNumber++;

        return [
            $rowNumber,
            $technician->getFullNameAttribute(),
            $technician->email,
            $technician->phone,
            $technician->department,
            $technician->designation,
            $technician->specialization,
            $technician->qualification,
            $technician->status ? 'Active' : 'Inactive',
            $technician->created_at->format('Y-m-d H:i:s')
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}