<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class StudentExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize, WithStyles
{
    protected $query;

    public function __construct($query)
    {
        $this->query = $query;
    }

    public function query()
    {
        return $this->query;
    }

    public function headings(): array
    {
        return [
            'First Name',
            'Last Name',
            'Academic ID',
            'Email',
            'Mobile Number',
            'Department',
            'Year of Study',
            'Principal Investigator',
            'Lab',
            'Status',
            'Created At'
        ];
    }

    public function map($student): array
    {
        return [
            $student->first_name,
            $student->last_name,
            $student->academic_id,
            $student->email,
            $student->mobile_number,
            $student->department,
            $student->year_of_study,
            $student->principalInvestigator->getFullNameAttribute(),
            $student->principalInvestigator->labs ? $student->principalInvestigator->labs->lab_name : 'N/A',
            $student->status ? 'Active' : 'Inactive',
            $student->created_at->format('Y-m-d H:i:s')
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}