<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class StockTransactionExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize, WithStyles
{
    protected $query;

    public function __construct($query)
    {
        $this->query = $query;
    }

    public function query()
    {
        return $this->query;
    }

    public function headings(): array
    {
        return [
            'ID',
            'Item Name',
            'Category',
            'Item Type',
            'Transaction Type',
            'Quantity',
            'Remaining Quantity',
            'Transaction Date',
            'Used For',
            'Conducted By',
            'Approved By',
            'Batch Number',
            'Supplier',
            'Notes',
            'Created At'
        ];
    }

    public function map($transaction): array
    {
        return [
            $transaction->id,
            $transaction->inventoryItem->name ?? 'N/A',
            $transaction->inventoryItem->category->name ?? 'N/A',
            ucfirst($transaction->inventoryItem->item_type ?? 'regular'),
            ucfirst($transaction->transaction_type),
            $transaction->quantity,
            $transaction->remaining_quantity,
            $transaction->transaction_date->format('Y-m-d'),
            $transaction->used_for ?? 'N/A',
            $transaction->conducted_by,
            $transaction->approved_by ?? 'N/A',
            $transaction->batch->batch_number ?? 'N/A',
            $transaction->batch->supplier->name ?? 'N/A',
            $transaction->notes ?? 'N/A',
            $transaction->created_at->format('Y-m-d H:i:s')
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}