<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class StockAlertExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize, WithStyles
{
    protected $query;

    public function __construct($query)
    {
        $this->query = $query;
    }

    public function query()
    {
        return $this->query;
    }

    public function headings(): array
    {
        return [
            'ID',
            'Item Name',
            'Category',
            'Alert Type',
            'Alert Message',
            'Status',
            'Resolved By',
            'Resolved At',
            'Batch Number',
            'Expiry Date',
            'Current Stock',
            'Min Stock Level',
            'Created At'
        ];
    }

    public function map($alert): array
    {
        return [
            $alert->id,
            $alert->inventoryItem->name ?? 'N/A',
            $alert->inventoryItem->category->name ?? 'N/A',
            ucfirst(str_replace('_', ' ', $alert->alert_type)),
            $alert->alert_message,
            $alert->resolved ? 'Resolved' : 'Active',
            $alert->resolved_by ?? 'N/A',
            $alert->resolved_at ? $alert->resolved_at->format('Y-m-d H:i:s') : 'N/A',
            $alert->batch->batch_number ?? 'N/A',
            $alert->batch && $alert->batch->expiry_date ? $alert->batch->expiry_date->format('Y-m-d') : 'N/A',
            $alert->inventoryItem ? $alert->inventoryItem->getCurrentStock() : 'N/A',
            $alert->inventoryItem->min_stock_level ?? 'N/A',
            $alert->created_at->format('Y-m-d H:i:s')
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}