<?php

namespace App\Exports;

use App\Models\piFund;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class PiExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize, WithStyles
{
    protected $query;

    public function __construct($query)
    {
        $this->query = $query;
    }

    public function collection()
    {
        return $this->query->get();
    }

    public function headings(): array
    {
        return [
            'Sr. No.',
            'Name',
            'Email',
            'Phone',
            'Department',
            'Designation',
            'Specialization',
            'Qualification',
            'Status',
            'Available Funds',
            'Created At'
        ];
    }

    public function map($pi): array
    {
        static $rowNumber = 0;
        $rowNumber++;

        return [
            $rowNumber,
            $pi->getFullNameAttribute(),
            $pi->email,
            $pi->phone,
            $pi->department,
            $pi->designation,
            $pi->specialization,
            $pi->qualification,
            $pi->status ? 'Active' : 'Inactive',
            number_format($pi->available_funds, 2),
            $pi->created_at->format('Y-m-d H:i:s')
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}
