<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class InstrumentExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize, WithStyles
{
    protected $query;

    public function __construct($query)
    {
        $this->query = $query;
    }

    public function query()
    {
        return $this->query;
    }

    public function headings(): array
    {
        return [
            'Name',
            'Category',
            'Lab',
            'Model Number',
            'Serial Number',
            'Per Hour Cost',
            'Operating Status',
            'Engineer Name',
            'Engineer Contact',
            'Created At'
        ];
    }

    public function map($instrument): array
    {
        return [
            $instrument->name,
            $instrument->instrumentCategory ? $instrument->instrumentCategory->title : 'N/A',
            $instrument->lab ? $instrument->lab->lab_name : 'N/A',
            $instrument->model_number,
            $instrument->serial_number,
            $instrument->booking_cost,
            ucfirst($instrument->operating_status),
            $instrument->engineer_name,
            $instrument->engineer_email . ' / ' . $instrument->engineer_mobile,
            $instrument->created_at->format('Y-m-d H:i:s')
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}
