<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class ExpiryReportExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize, WithStyles
{
    protected $query;

    public function __construct($query)
    {
        $this->query = $query;
    }

    public function query()
    {
        return $this->query;
    }

    public function headings(): array
    {
        return [
            'Item Name',
            'Category',
            'Item Type',
            'Batch Number',
            'Expiry Date',
            'Days Until Expiry',
            'Current Quantity',
            'Supplier',
            'Status'
        ];
    }

    public function map($batchItem): array
    {
        $daysUntilExpiry = $batchItem->expiry_date ? now()->diffInDays($batchItem->expiry_date, false) : null;
        $status = 'Active';
        
        if ($batchItem->expiry_date) {
            if ($batchItem->expiry_date->isPast()) {
                $status = 'Expired';
            } elseif ($daysUntilExpiry <= 30) {
                $status = 'Expiring Soon';
            }
        }

        return [
            $batchItem->inventoryItem->name ?? 'N/A',
            $batchItem->inventoryItem->category->name ?? 'N/A',
            ucfirst($batchItem->inventoryItem->item_type ?? 'regular'),
            $batchItem->stockBatch->batch_number ?? 'N/A',
            $batchItem->expiry_date ? $batchItem->expiry_date->format('Y-m-d') : 'N/A',
            $daysUntilExpiry !== null ? $daysUntilExpiry : 'N/A',
            $batchItem->current_quantity,
            $batchItem->stockBatch->supplier->name ?? 'N/A',
            $status
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}