<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class ConsumptionReportExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize, WithStyles
{
    protected $query;

    public function __construct($query)
    {
        $this->query = $query;
    }

    public function query()
    {
        return $this->query;
    }

    public function headings(): array
    {
        return [
            'Item Name',
            'Category',
            'Item Type',
            'Transaction Date',
            'Quantity Used',
            'Used For',
            'Conducted By',
            'Approved By',
            'Batch Number',
            'Remaining Quantity'
        ];
    }

    public function map($transaction): array
    {
        return [
            $transaction->inventoryItem->name ?? 'N/A',
            $transaction->inventoryItem->category->name ?? 'N/A',
            ucfirst($transaction->inventoryItem->item_type ?? 'regular'),
            $transaction->transaction_date->format('Y-m-d'),
            $transaction->quantity,
            $transaction->used_for ?? 'N/A',
            $transaction->conducted_by,
            $transaction->approved_by ?? 'N/A',
            $transaction->batch->batch_number ?? 'N/A',
            $transaction->remaining_quantity
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}