<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class BookingExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize, WithStyles
{
    protected $query;

    public function __construct($query)
    {
        $this->query = $query;
    }

    public function query()
    {
        return $this->query;
    }

    public function headings(): array
    {
        return [
            'Sr. No.',
            'Student Name',
            'Academic ID',
            'Instrument',
            'Date',
            'Time Slot',
            'Status',
            'Description'
        ];
    }

    public function map($booking): array
    {
        static $rowNumber = 0;
        $rowNumber++;

        return [
            $rowNumber,
            $booking->student->first_name . ' ' . $booking->student->last_name,
            $booking->student->academic_id,
            $booking->instrument->name,
            $booking->date,
            $booking->slot->start_time . ' - ' . $booking->slot->end_time,
            ucfirst($booking->status),
            $booking->description ?? '--'
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}